#ifdef _DEBUG
# define NAME(x) case x: return #x

namespace {
	LPCSTR EventName(MediaEventType met) {
		switch(met) {
			NAME(MEError);
			NAME(MEExtendedType);
			NAME(MESessionTopologySet);
			NAME(MESessionTopologiesCleared);
			NAME(MESessionStarted);
			NAME(MESessionPaused);
			NAME(MESessionStopped);
			NAME(MESessionClosed);
			NAME(MESessionEnded);
			NAME(MESessionRateChanged);
			NAME(MESessionScrubSampleComplete);
			NAME(MESessionCapabilitiesChanged);
			NAME(MESessionTopologyStatus);
			NAME(MESessionNotifyPresentationTime);
			NAME(MENewPresentation);
			NAME(MELicenseAcquisitionStart);
			NAME(MELicenseAcquisitionCompleted);
			NAME(MEIndividualizationStart);
			NAME(MEIndividualizationCompleted);
			NAME(MEEnablerProgress);
			NAME(MEEnablerCompleted);
			NAME(MEPolicyError);
			NAME(MEPolicyReport);
			NAME(MEBufferingStarted);
			NAME(MEBufferingStopped);
			NAME(MEConnectStart);
			NAME(MEConnectEnd);
			NAME(MEReconnectStart);
			NAME(MEReconnectEnd);
			NAME(MERendererEvent);
			NAME(MESessionStreamSinkFormatChanged);
			NAME(MESourceStarted);
			NAME(MEStreamStarted);
			NAME(MESourceSeeked);
			NAME(MEStreamSeeked);
			NAME(MENewStream);
			NAME(MEUpdatedStream);
			NAME(MESourceStopped);
			NAME(MEStreamStopped);
			NAME(MESourcePaused);
			NAME(MEStreamPaused);
			NAME(MEEndOfPresentation);
			NAME(MEEndOfStream);
			NAME(MEMediaSample);
			NAME(MEStreamTick);
			NAME(MEStreamThinMode);
			NAME(MEStreamFormatChanged);
			NAME(MESourceRateChanged);
			NAME(MEEndOfPresentationSegment);
			NAME(MESourceCharacteristicsChanged);
			NAME(MESourceRateChangeRequested);
			NAME(MESourceMetadataChanged);
			NAME(MESequencerSourceTopologyUpdated);
			NAME(MEStreamSinkStarted);
			NAME(MEStreamSinkStopped);
			NAME(MEStreamSinkPaused);
			NAME(MEStreamSinkRateChanged);
			NAME(MEStreamSinkRequestSample);
			NAME(MEStreamSinkMarker);
			NAME(MEStreamSinkPrerolled);
			NAME(MEStreamSinkScrubSampleComplete);
			NAME(MEStreamSinkFormatChanged);
			NAME(MEStreamSinkDeviceChanged);
			NAME(MEQualityNotify);
			NAME(MESinkInvalidated);
			NAME(MEAudioSessionNameChanged);
			NAME(MEAudioSessionVolumeChanged);
			NAME(MEAudioSessionDeviceRemoved);
			NAME(MEAudioSessionServerShutdown);
			NAME(MEAudioSessionGroupingParamChanged);
			NAME(MEAudioSessionIconChanged);
			NAME(MEAudioSessionFormatChanged);
			NAME(MEAudioSessionDisconnected);
			NAME(MEAudioSessionExclusiveModeOverride);
			NAME(MEPolicyChanged);
			NAME(MEContentProtectionMessage);
			NAME(MEPolicySet);
			NAME(MEStreamSinkFormatInvalidated);
		default:
			return "Unknown event";
		}
	}
}
#endif
