#pragma once

#include "HttpTimer.hpp"

namespace twitch {
namespace windows {

    class HttpRequest;

    class HttpClient : public twitch::HttpClient {
    public:
        HttpClient();
        ~HttpClient() override;

        std::shared_ptr<twitch::HttpRequest> createRequest(const std::string& url, twitch::HttpMethod method /* = HttpMethod::GET */) override;

        void send(std::shared_ptr<twitch::HttpRequest> request, ResponseHandler onResponse, ErrorHandler onError) override;

    private:
        HINTERNET m_httpSession;
    };

    class HttpResponse : public twitch::HttpResponse, public std::enable_shared_from_this<HttpResponse> {
    public:
        HttpResponse(HINTERNET httpRequest, HttpClient::ResponseHandler onResponse, ErrorHandler onError);
        ~HttpResponse() override = default;

        void Initialize();
        std::string getHeader(const std::string& key) const override;
        void read(ContentHandler onBuffer, ErrorHandler onError) override;
        void cancel();

    private:
        bool OnStatusChanged(DWORD status, LPVOID information, DWORD size);
        static void WINAPI OnStatusChanged(HINTERNET request, DWORD_PTR context, DWORD status, LPVOID information, DWORD size);

    private:
        HINTERNET m_httpResponse;
        HttpClient::ResponseHandler m_onResponse;
        ErrorHandler m_onError;
        std::shared_ptr<HttpTimer> m_timer;
        ContentHandler m_onContent;
        std::array<uint8_t, 0x2000ul> m_data;
    };

}
}
