#include "pch.h"
#include "HttpRequest.hpp"

namespace {
    HINTERNET CreateConnection(HINTERNET httpSession, std::string const& url) {
        auto i = url.find('/') + 2;
        auto j = url.find('/', i);
        auto k = url.rfind(':', j);
        auto hostName = k < i ?
            std::wstring(url.cbegin() + i, j == url.npos ? url.cend() : url.cbegin() + j) :
            std::wstring(url.cbegin() + i, url.cbegin() + k);
        auto port = static_cast<INTERNET_PORT>(k < i ? INTERNET_DEFAULT_PORT : std::stoi(url.substr(k + 1)));
        auto httpConnection = WinHttpConnect(httpSession, hostName.c_str(), port, 0);
        if(!httpConnection) {
            TRACE_ERROR("CreateConnection.WinHttpConnect error %d", GetLastError());
            throw std::runtime_error("CreateConnection.WinHttpConnect");
        }
        return httpConnection;
    }

    HINTERNET CreateRequest(HINTERNET httpConnection, std::string const& url, LPCWSTR verb) {
        auto i = url.find('/');
        i = url.find('/', i + 2);
        auto objectName = i == url.npos ? L"/" : std::wstring(url.cbegin() + i, url.cend());
        bool isHttps = !strncmp(url.c_str(), "https", 5);
        auto httpRequest = WinHttpOpenRequest(httpConnection, verb, objectName.c_str(), nullptr,
            WINHTTP_NO_REFERER, WINHTTP_DEFAULT_ACCEPT_TYPES, isHttps ? WINHTTP_FLAG_SECURE : 0);
        if(!httpRequest) {
            TRACE_ERROR("CreateConnection.WinHttpConnect error %d", GetLastError());
            throw std::runtime_error("CreateConnection.WinHttpConnect");
        }
        return httpRequest;
    }
}

using namespace twitch::windows;

HttpRequest::HttpRequest(HINTERNET httpSession, const std::string& url, twitch::HttpMethod method)
    : twitch::HttpRequest(url, method)
    , m_httpConnection(CreateConnection(httpSession, url))
{
    TRACE_DEBUG("HttpRequest::HttpRequest");
}

HttpRequest::~HttpRequest()
{
    TRACE_DEBUG("HttpRequest::~HttpRequest");
    verify(!m_httpConnection || WinHttpCloseHandle(m_httpConnection));
}

void HttpRequest::send(HttpClient::ResponseHandler onResponse, HttpClient::ErrorHandler onError)
{
    TRACE_DEBUG("HttpRequest::send() - Requesting URL: %s", getUrl().c_str());
    auto httpRequest = CreateRequest(m_httpConnection, getUrl(), AsWstring(getMethodString()).c_str());
    try {
        m_response = std::make_shared<HttpResponse>(httpRequest, onResponse, onError);
        m_response->Initialize();
    } catch(...) {
        WinHttpCloseHandle(httpRequest);
        throw;
    }
}

void HttpRequest::setHeader(const std::string& key, const std::string& value)
{
    m_headers[key] = value;
}

void HttpRequest::setContent(const std::vector<uint8_t>& content)
{
    (void)content;
    // TODO support request content
}

void HttpRequest::cancel()
{
    TRACE_DEBUG("HttpRequest::cancel()");
    if(m_response) {
        m_response->cancel();
        m_response.reset();
    } else {
        TRACE_WARN("HttpRequest::cancel:  nothing to cancel");
    }
}
