#pragma once

#include "playercore/platform/HttpRequest.hpp"
#include "HttpClient.hpp"

namespace twitch {
namespace windows {

class HttpRequest : public twitch::HttpRequest, public std::enable_shared_from_this<HttpRequest> {
public:
    HttpRequest(HINTERNET httpSession, const std::string& url, twitch::HttpMethod method = HttpMethod::GET);
    ~HttpRequest() override;

    void send(HttpClient::ResponseHandler onResponse, HttpClient::ErrorHandler onError);

    void setHeader(const std::string& key, const std::string& value) override;
    void setContent(const std::vector<uint8_t>& content) override;

private:
    void cancel() override;

private:
    HINTERNET m_httpConnection;

    twitch::HttpHeaderMap m_headers;
    std::shared_ptr<HttpResponse> m_response;
};

}
}
