#include "pch.h"
#include "HttpTimer.hpp"

using namespace Concurrency;
#ifdef __cplusplus_winrt
using namespace Platform;
using namespace Windows::Foundation::Collections;
using namespace Windows::Storage::Streams;
using namespace Windows::Web::Http;
#endif

namespace twitch {
namespace windows {

HttpTimer::~HttpTimer()
{
    setTimeoutFunction(nullptr);
}

void HttpTimer::onCallback()
{
    std::lock_guard<RecursiveMutex> lock(m_mutex);

    if (m_onTimeout && !m_timeout) {
        m_timeout = true;
        m_onTimeout();
        TRACE_DEBUG("HttpTimer last sync point reached is %d", m_lastSyncPointReached);
    }
}

void HttpTimer::start()
{
    std::lock_guard<RecursiveMutex> lock(m_mutex);

    if (hasTimedOut()) {
        return;
    }
    m_timer->start();
}

void HttpTimer::stop()
{
    std::lock_guard<RecursiveMutex> lock(m_mutex);

    if (hasTimedOut()) {
        return;
    }
    m_timer->stop();
}

void HttpTimer::restart()
{        
    std::lock_guard<RecursiveMutex> lock(m_mutex);

    if (hasTimedOut()) {
        return;
    }

    m_timer->stop();
    m_timer = std::unique_ptr<concurrency::timer<int>>(new concurrency::timer<int>(static_cast<unsigned int>(std::chrono::duration_cast<std::chrono::milliseconds>(m_originalTimeoutMs).count()), 0, &m_callback, false));
}


void HttpTimer::forceTimeout()
{
    onCallback();
}

void HttpTimer::syncPoint(int syncPoint)
{
    m_lastSyncPointReached = syncPoint;

#if HTTPTIMER_SIMULATE_TIMEOUT
    if (m_lastSyncPointReached == m_syncPoint) {
        forceTimeout();
    }
#endif
}

void HttpTimer::setTimeoutFunction(std::function<void()>&& onTimeout)
{
    std::lock_guard<RecursiveMutex> lock(m_mutex);
    m_onTimeout = std::move(onTimeout);
}

bool HttpTimer::hasTimedOut()
{
    return m_timeout;
}

}
}
