#include "pch.h"
#include "Log.hpp"
#include "platform/NativePlatform.hpp"

using namespace twitch::windows;

void PrintLog::log(Level level, const char* format, va_list args) const
{
    twitch::PrintLog::log(level, format, args);

    if (!NativePlatform::getLogMessageHandler()) {
        std::string formatted = getFormatted(format, args);
        formatted.append("\n");
        OutputDebugStringA(formatted.c_str());
    }
}

void PrintLog::setConsoleMaxBufferSize()
{
    HANDLE consoleHandle = GetStdHandle(STD_OUTPUT_HANDLE);
    if (consoleHandle != 0) {
        COORD bufferSize = {PrintLog::MaxLength, 9999};
        SetConsoleScreenBufferSize(consoleHandle, bufferSize);
    }
}

PrintLog::PrintLog()
{
    setConsoleMaxBufferSize();
}
