#include "pch.h"
#include "debug/trace.hpp"
#include "checkhr.hpp"
#include "playercore/platform/windows/WindowsPlatform.hpp"
#include "MediaSample.hpp"

using namespace twitch;
using namespace twitch::windows;
using namespace Microsoft;
using namespace Microsoft::WRL;

windows::MediaSample::MediaSample(IMFSample* sample)
{
    initialize(sample);
}

MediaResult windows::MediaSample::initialize(IMFSample* sample)
{
    LONGLONG sampleTime;
    CHECK_HR(sample->GetSampleTime(&sampleTime), "Can't get sample time from IMFSample");

    LONGLONG sampleDuration;
    CHECK_HR(sample->GetSampleDuration(&sampleDuration), "Can't get sample duration from IMFSample");

    // Time is in 100 nanoseconds range. So that's 0.1 microsecond. We are interested in MediaTime which is microsecond based.
    this->duration = MediaTime(sampleDuration / 10, std::micro::den);
    this->decodeTime = this->presentationTime = MediaTime(sampleTime / 10, std::micro::den);

    return MediaResult::Ok;
}

bool windows::MediaSample::extractBuffer(IMFSample* sample)
{
    ComPtr<IMFMediaBuffer> mediaBuffer;
    HRESULT hr = sample->ConvertToContiguousBuffer(&mediaBuffer);

    if (FAILED(hr)) {
        WindowsPlatform::hError("ConvertToContiguousBuffer failed", hr);
        return false;
    }

    BYTE* pMediaBuffer;
    DWORD bufferMaxLength;
    DWORD bufferLength;
    hr = mediaBuffer->Lock(&pMediaBuffer, &bufferMaxLength, &bufferLength);

    if (FAILED(hr)) {
        WindowsPlatform::hError("Can't lock buffer", hr);
        return false;
    }

    buffer.resize(bufferLength);
    memcpy(buffer.data(), pMediaBuffer, bufferLength);
    mediaBuffer->Unlock();

    return true;
}
