#include "pch.h"
#include "playercore/platform/windows/PlayerCore.hpp"
#include "debug/debugplayer.hpp"
#include "VideoSample.hpp"
#include "player/AsyncMediaPlayer.hpp"

namespace twitch {
namespace windows {

std::shared_ptr<twitch::Player> PlayerCore::create(Player::Listener& listener, PlayerCore::OnRenderFrame onRenderFrame, Microsoft::WRL::ComPtr<ID3D11Device> device,
                                                   MediaSource::Request::Listener* requestListener)
{
    auto platform = std::make_shared<WindowsPlatform>(device, onRenderFrame);
#ifdef NDEBUG
    return std::make_shared<twitch::AsyncMediaPlayer>(listener, platform, requestListener);
 #else
    return std::make_shared<twitch::DebugMediaPlayer>(listener, platform, requestListener);
#endif
}

Microsoft::WRL::ComPtr<ID3D11Texture2D> PlayerCore::getTextureFromVideoSample(const twitch::MediaSampleBuffer &videoSample)
{
    if (videoSample.type == MediaSample::Type::Opaque) {
        return static_cast<const VideoSample *>(&videoSample)->getTexture();
    }

    return Microsoft::WRL::ComPtr<ID3D11Texture2D>();
}

}
}
