#include "pch.h"
#include "Semaphore.hpp"
#include "debug/trace.hpp"

using namespace twitch;
using namespace twitch::windows;

Semaphore::Semaphore(LONG initialCount)
{
    m_semaphore = CreateSemaphore(NULL, initialCount, initialCount, NULL);
    m_changedEvent = CreateEvent(NULL, FALSE, FALSE, NULL);

    m_initialCount = m_lastCount = initialCount;
}

Semaphore::~Semaphore()
{
    CloseHandle(m_semaphore);
    CloseHandle(m_changedEvent);
}

void Semaphore::notify()
{
    DWORD result = ReleaseSemaphore(m_semaphore, 1, NULL);
    assert(result);
    (void)result;

    m_lastCount++;
    SetEvent(m_changedEvent);
}

bool Semaphore::wait(LONG milliseconds)
{
    DWORD result = WaitForSingleObject(m_semaphore, IsDebuggerPresent() ? INFINITE : milliseconds);
    if (result == WAIT_OBJECT_0)
    {
        m_lastCount--;
        return true;
    }
    else
    {
        assert(result == WAIT_TIMEOUT);
        return false;
    }
}

unsigned long Semaphore::count() const
{
    return m_lastCount;
}

// This function waits until the unsignaled semaphore state goes back to m_initialCount. It makes no guaranteed that the state is still completely unsignaled once
// it has returned however.
void Semaphore::waitForOrigin()
{
    while (m_lastCount != m_initialCount) {
        DWORD result = WaitForSingleObject(m_changedEvent, INFINITE);
        assert(result == WAIT_OBJECT_0);
        (void)result;
    }
}
