#pragma once

namespace twitch {
namespace windows {
    class Semaphore {
    public:
        Semaphore() = default;
        Semaphore(LONG initialCount);
        ~Semaphore();

        void notify();

        // Return true if the Semaphore was available, false if it timed out
        bool wait(LONG milliseconds);
        unsigned long count() const;

        void waitForOrigin();

        Semaphore(const Semaphore& rhs) = delete;
        Semaphore operator=(const Semaphore& rhs) = delete;

    private:
        HANDLE m_semaphore = NULL;
        std::atomic<LONG> m_lastCount;

        LONG m_initialCount;

        HANDLE m_changedEvent;
    };
}
}
