#pragma once

namespace twitch {
namespace windows {

	class Transform {
	public:
		static HRESULT Create(IMFMediaType* mediaType, std::unique_ptr<Transform>& p);
		~Transform() = default;
		HRESULT Finish(IMFSinkWriter* writer);
		Microsoft::WRL::ComPtr<IMFMediaType> GetMediaType() const { return m_mediaType; }
		HRESULT Write(IMFSample* sample, IMFSinkWriter* writer);
		__declspec(property(get = GetMediaType)) Microsoft::WRL::ComPtr<IMFMediaType> MediaType;

	private:
		MFT_OUTPUT_STREAM_INFO m_info{};
		Microsoft::WRL::ComPtr<IMFTransform> m_transform;
		Microsoft::WRL::ComPtr<IMFMediaType> m_mediaType;

		Transform(IMFMediaType* mediaType, HRESULT& hr);
		HRESULT WriteTransformedSamples(IMFSinkWriter* writer);
	};

}
}
