#pragma once

#include "playercore/platform/windows/WindowsPlatform.hpp"
#include "playercore/ReferenceClock.hpp"
#include "playercore/platform/VideoRenderer.hpp"

namespace twitch {
namespace windows {
    class VideoRenderer : public twitch::VideoRenderer {
    public:
        VideoRenderer(WindowsPlatform::OnRenderFrame onRenderFrame, const ReferenceClock& clock);
        virtual ~VideoRenderer();

        MediaResult configure(const MediaFormat& format) override;
        MediaResult render(std::shared_ptr<const twitch::MediaSample> input) override;
        MediaResult getDroppedFrames(int& count) override;
        MediaResult getRenderedFrames(int& count) override;
        MediaResult getRenderedPresentationTime(MediaTime& time) override;

        MediaResult start() override;
        MediaResult stop() override;
        MediaResult flush() override;

        MediaResult setPlaybackRate(float rate) override;

    protected:
    private:
        WindowsPlatform::OnRenderFrame m_onRenderFrame;
        const ReferenceClock& m_clock;
        MediaTime m_lastRenderedPresentationTime;
        int m_renderedFrames = 0;
        int m_droppedFrames = 0;
        int m_width = 0;
        int m_height = 0;
    };
}
}
