#include "pch.h"
#include "VideoSample.hpp"
#include "playercore/platform/windows/WindowsPlatform.hpp"

using namespace twitch;
using namespace windows;

namespace {
    void ThrowFailure(HRESULT hr) {
        if(FAILED(hr)) {
#ifdef __cplusplus_winrt
            throw ::Platform::Exception::CreateException(hr);
#else
            throw std::runtime_error("VideoSample error " + std::to_string(hr));
#endif
        }
    }
}

VideoSample::VideoSample(IMFSample* sample)
    : MediaSample(sample)
{
    type = MediaSample::Type::Opaque;

    Microsoft::WRL::ComPtr<IMFMediaBuffer> mediaBuffer;
    ThrowFailure(sample->GetBufferByIndex(0, &mediaBuffer));

    Microsoft::WRL::ComPtr<IMFDXGIBuffer> dxgiBuffer;
    ThrowFailure(mediaBuffer.As(&dxgiBuffer));

    ThrowFailure(dxgiBuffer->GetResource(IID_PPV_ARGS(&m_texture)));
}
