#pragma once

#ifdef __cplusplus_winrt
# include <dxgi1_4.h>
# include <d3d11_3.h>
#else
# include "targetver.h"

# define WIN32_LEAN_AND_MEAN

// https://docs.microsoft.com/en-us/windows/desktop/direct3darticles/platform-update-for-windows-7
# include <d3d11_1.h>
# include <dxgi1_2.h>
#endif

#include <agents.h>
#include <Codecapi.h>
#include <immintrin.h>
#include <mfapi.h>
#include <MfError.h>
#include <mfidl.h>
#include <mfreadwrite.h>
#include <ppltasks.h>
#include <wmcodecdsp.h>
#include <wrl.h>
#ifdef __cplusplus_winrt
# include <Xaudio2.h>
#endif
#include <xmmintrin.h>

#include <algorithm>
#include <array>
#include <cassert>
#include <chrono>
#include <codecvt>
#include <condition_variable>
#include <cwctype>
#include <functional>
#include <future>
#include <list>
#include <locale>
#include <memory>
#include <mutex>
#include <string>
#include <thread>
#include <unordered_set>

#ifndef __cplusplus_winrt
# include <direct.h>
# include <Shlwapi.h>
# include <winhttp.h>

# undef DELETE

# include <iomanip>
# include <random>
# include <sstream>
# include <vector>

# ifdef _DEBUG
#  define verify assert
# else
#  define verify(x) ((void)(x))
# endif

# define ReturnFailure(hr) do { HRESULT hr_ = (hr); if(FAILED(hr_)) return hr_; } while(false)

template<typename T>
inline std::wstring AsWstring(T const& value) {
	return std::wstring(value.cbegin(), value.cend());
}

class CriticalLock {
public:
	CriticalLock(CRITICAL_SECTION& criticalSection) : criticalSection(criticalSection) { EnterCriticalSection(&criticalSection); }
	~CriticalLock() { LeaveCriticalSection(&criticalSection); }

private:
	CRITICAL_SECTION& criticalSection;
};

struct PropVariant : public PROPVARIANT {
	PropVariant() { PropVariantInit(this); }
	~PropVariant() { PropVariantClear(this); }
};

template<typename T>
struct CoTaskMemPtr {
	CoTaskMemPtr() : p(nullptr) {}
	~CoTaskMemPtr() { CoTaskMemFree(p); }
	operator void const*() { return p; }
	T** operator&() { return &p; }
	T* operator->() { return p; }

private:
	T* p;
};
#endif
