'''
Video Player
Automation Framework
'''
import core
import jobs
import sys
from adaptor.dockersdk import DockerAdaptor

''' Run job '''
def runJob(config, job):
    core.log.message('  CleanJob: ' + str(config.getJobClean()))
    core.log.message('   SkipJob: ' + str(config.getJobSkip()))
    core.log.message('JobTimeout: ' + str(config.getJobTimeoutSec()) + ' seconds')
    core.log.message('   RootDir: ' + config.getRootDir())
    core.log.message('   WorkDir: ' + config.getWorkDir())
    core.log.message('    OutDir: ' + config.getOutDir())
    if config.getJobClean(): core.log.message('Cleaning work and output directories...')
    core.shell.mkdir(config.getWorkDir(), config.getJobClean())
    core.shell.mkdir(config.getOutDir(), True)
    exit = job.execute(config)
    return exit

''' Run job in docker '''
def runJobInDocker(config):
    dockerAdaptor = DockerAdaptor(config)
    return dockerAdaptor.runContainer(config, dockerAdaptor.buildImage(config))
   
''' Entry Point '''
def main():
    core.log.init()
    ''' Parse environment '''
    try:
        config = core.env.Config()
    except core.const.AutoException as e:
        sys.exit(e.getValue())
    except Exception as e:
        core.log.error('Unhandled exception: '+str(e), exit=False)
        sys.exit(1)

    ''' Skip job if requested '''
    if config.getJobSkip():
        core.log.message('Job skip requested, exiting...')
        sys.exit(0)
    
    ''' Resolve job '''
    try: job = jobs.routes.getJobRoutes().get(config.getPlatform()).get(config.getAction())
    except Exception as e:
        core.log.message('Caught exception: '+str(e))
        core.log.error('Job for '+str(config.getPlatform()) + '->'+str(config.getAction()) + ' does not exist', exit=False)
        sys.exit(1)
    
    ''' Run job '''
    exit = 0
    try:
        if not config.getDockerInvoke():
            core.log.job_prologue(config)
            exit = runJob(config, job())
        else:
            exit = runJobInDocker(config)
    except core.const.AutoException as e:
        exit = e.getValue()
    except Exception as e:
        core.log.error('Unhandled exception: '+str(e), exit=False)
        exit = 1
    if not config.getDockerInvoke():
        core.log.job_epilogue( config, exit )
    sys.exit(exit)

''' Boostrap '''
if __name__ == '__main__': main()
