'''
Android Debug Bridge (ADB) Adaptor
'''
import core

class AdbAdaptor:
    ''' Constructor '''
    def __init__(self):
        core.log.message('Creating ADB Adaptor')
        self.emulator = Emulator(self)
 
    ''' Connect to an ADB device '''
    def connect(self, ip ):
        core.shell.run(cmd='adb connect '+ip)

    ''' Device management/queries '''
    def devices(self, options):
        ''' selectedHardwareDevice=$(adb devices -l | grep usb | cut -d ' ' -f 1) '''
        core.shell.run(cmd='adb devices '+options)

    def logcat(self, options):
        core.shell.run(cmd='adb logcat '+options)
        ''' adb logcat -c '''
        ''' adb logcat -s "Twitch" | tee ${adbDeviceLog} & logcatPid=$! '''
    
    ''' Run shell command '''
    def shell(self, options):
        core.shell.run(cmd='adb shell '+options)
        '''adb shell am start -n tv.twitch.android.player.test/.TestActivity -a android.intent.action.MAIN -c android.intent.category.LAUNCHER --es url \"${gTestArgUrl}\" --es gfilter \"${gTestArgTestFilter}\" --es gxml \"${gTestArgXml}\" '''
    
    ''' Emulator '''
    class Emulator:
        def __init__(self, name):
            self.name = name
        def create(self, sysImage='system-images;android-24;google_apis;x86', options='-f --tag google_apis'):
            core.shell.run(cmd='avdmanager -s create avd -n '+self.name+' -k '+sysImage+' ' +options, shell=True)
        def start(self, options = '-no-audio -no-window -no-boot-anim -no-snapshot'):
            core.shell.run(cmd='emulator -avd '+self.name+' '+options, shell=True)
        def stop(self):
            ''' adb devices | grep <device> | cut -f1 | while read line; do adb -s $line emu kill; done '''
            pass
        def install(self, apkPath):
            core.shell.run(cmd='adb -e install -r '+apkPath, shell=True)
