'''
    AWS Boto3 Adaptor
'''
import core
import boto3

class Boto3Adaptor:
    ''' Constructor '''
    def __init__(self, config, service):
        core.log.message('Creating Boto3 adaptor')
        region = config.parseString('AUTO_AWS_REGION')
        accessKey = config.parseString('AUTO_AWS_ACCESSKEY')
        secretKey = config.parseString('AUTO_AWS_SECRETKEY')
        core.log.message('- Service: '+service)
        core.log.message('- Region: '+region)
        core.log.message('- AccessKey: '+accessKey)
        core.log.message('- SecretKey: *****')
        self.client = boto3.client(service, region_name=region, aws_access_key_id=accessKey, aws_secret_access_key=secretKey)
        if not self.client:
            core.log.error('Unable to create boto3 client for service "'+service+'"')
        # Also enable aws-cli
        config.writeEnvVar('AWS_ACCESS_KEY_ID', accessKey)
        config.writeEnvVar('AWS_SECRET_ACCESS_KEY', secretKey)
        config.writeEnvVar('AWS_DEFAULT_REGION', region)
