'''
CMake Adaptor
'''
import core

class CMakeAdaptor:
    ''' Constructor '''
    def __init__(self, generator, executable = 'cmake', root = '.', buildType = None, toolChain = None, params = None, contextDir = None, env = None):
        core.log.message('Creating CMake adaptor')
        self.version = core.shell.capture(executable+' --version').decode().strip()
        self.generator = generator
        self.executable = executable
        self.root = root
        self.buildType = buildType
        self.toolChain = toolChain
        self.params = params
        self.contextDir = contextDir
        self.env = env
        core.log.message('- Version: '+self.version)
        core.log.message('- Generator: '+str(self.generator))
        core.log.message('- Executable: '+str(self.executable))
        core.log.message('- Root: '+str(self.root))
        core.log.message('- BuildType: '+str(self.buildType))
        core.log.message('- ToolChain: '+str(self.toolChain))
        core.log.message('- Params: '+str(self.params))
        core.log.message('- ContextDir: '+str(self.contextDir))
        core.log.message('- Env: '+str(self.env))

    ''' Generate project '''
    def generate(self, root = None, buildType = None, params = None, toolChain = None, contextDir = None, exitOnError=True, env=None):
        if not root: root = self.root
        if not buildType: buildType = self.buildType
        if not params: params = self.params
        if not toolChain: toolChain = self.toolChain
        if not contextDir: contextDir = self.contextDir
        if not env: env = self.env
        cmd = self.executable + ' -G' + self.generator + ' ' + root
        if buildType: cmd += ' -DCMAKE_BUILD_TYPE=' + buildType
        if toolChain: cmd += ' -DCMAKE_TOOLCHAIN_FILE=' + toolChain
        if params: cmd += ' ' + params
        result = core.shell.run( cmd=cmd, exitOnError=exitOnError, contextDir=contextDir, env=env )
        core.log.important('CMake created build files at "'+contextDir+'"')
        return result
     
    ''' Run CMAKE's build command with options '''
    def build(self, options='', buildToolOptions=None, contextDir=None, exitOnError=True, env=None):
        if not contextDir: contextDir = self.contextDir
        if not env: env = self.env
        cmd = self.executable + ' --build . ' + options
        if buildToolOptions: cmd += ' -- ' + buildToolOptions
        return core.shell.run( cmd=cmd, exitOnError=exitOnError, contextDir=contextDir, env=env )
        
