'''
    GIT Adaptor
'''
import core
import git

''' Initialize submodules '''
def submodule_init(contextDir=None, exitOnError=True):
    return core.shell.run('git submodule init', contextDir=contextDir, exitOnError=exitOnError)
    
''' Update submodules '''
def submodule_update(contextDir=None, exitOnError=True):
    return core.shell.run('git submodule update', contextDir=contextDir, exitOnError=exitOnError)

class GITAdaptor:
    ''' Constructor '''
    def __init__(self, config, server, repo='.'):
        core.log.message('Creating GIT adaptor')
        self.server = server
        self.repo = git.Repo(repo)
        core.log.message('- Server: '+self.server)
        core.log.message('- Repo: '+str(self.repo))
    
    ''' Submodule Init '''
    def submoduleInit(self, contextDir=None, exitOnError=True):
        return submodule_init(contextDir, exitOnError)
        
    ''' Submodule Update '''
    def submoduleInit(self, contextDir=None, exitOnError=True):
        return submodule_update(contextDir, exitOnError)

    ''' Create branch in current repo '''
    def createBranch(self, branch):
        return self.repo.git.branch(branch)
    
    ''' Checkout branch '''
    def checkoutBranch(self, branch):
        return self.repo.git.checkout(branch)

    ''' Add file to current branch '''
    def addFile(self, file):
        return self.addFiles([file])

    ''' Add files to current branch '''
    def addFiles(self, files):
        return self.repo.index.add(files)

    ''' Commit files '''
    def commit(self, message):
        return self.repo.index.commit(message)
    
    ''' Push to remote '''
    def push(self, branch):
        return self.repo.git.push('origin', branch)

    ''' Create and push tag to remote '''
    def tag(self, tag, message):
        tagObj = self.repo.create_tag(tag=tag, message=message)
        return self.repo.remotes.origin.push(tagObj)
