'''
Gradle Adaptor
'''
import core

class GradleAdaptor:
    ''' Constructor '''
    def __init__(self, config):
        core.log.message('Creating Gradle adaptor')
        if config.getJobClean():
            self._cleanIntermediates(config)

    ''' Clean intermediate objects '''
    def _cleanIntermediates(self, config):
        objects = ['.externalNativeBuild', '.gradle']
        for object in objects:
            core.log.message('Searching for object "'+object+'"...')
            matches = core.shell.find(object, config.getRootDir(), errorOnNotFound=False)
            for match in matches:
                core.log.message('- Removing: "' + match + '"')
                core.shell.remove(match)

    ''' Run gradlew '''
    def gradlew(self, config, options, contextDir, exitOnError=True):
        return core.shell.run(cmd='./gradlew '+options, contextDir = contextDir, exitOnError=exitOnError)

