'''
    NPM Adaptor
'''
import core

class NPMAdaptor:
    ''' Constructor '''
    def __init__(self, config):
        core.log.message('Creating NPM adaptor')
        self.version = core.shell.capture('npm --version').decode().strip()
        core.log.message('- Version: '+self.version)
        if config.getJobClean():
            core.log.message('Cleaning up intermediates...')
            core.shell.remove(config.getRootDir() + '/node_modules')
            core.shell.remove(config.getRootDir() + '/build_js')
            core.shell.remove(config.getRootDir() + '/artifacts')
    
    ''' Install '''
    def install(self, env=None):
        core.shell.run( cmd='npm install', env=env)

    ''' Run script '''
    def runScript(self, script, env=None):
        core.shell.run( cmd='npm run-script '+script, env=env)

    ''' Config '''
    def config(self, cmd, env=None):
        core.shell.run( cmd='npm config '+cmd, env=env)

    ''' Publish '''
    def publish(self, artifact, options='', env=None):
        core.shell.run( cmd='npm publish '+options+' '+artifact, env=env)
