'''
    PS4 Adaptor
'''
import core
import os

class PS4Adaptor:
    ''' Constructor '''
    def __init__(self, config):
        core.log.message('Creating PS4 adaptor')
        defaultSdkDir = config.parseString('SCE_ORBIS_SDK_DIR')
        core.log.message('- Default SDK: '+defaultSdkDir)
        if config.getPlatformSdk() != 'all':
            reqOrbisSdk = defaultSdkDir[:defaultSdkDir.rfind(os.sep)] + os.sep +config.getPlatformSdk()
            core.log.message('- Requested SDK: '+reqOrbisSdk)
            path = config.parseString('PATH')
            config.writeEnvVar('SCE_ORBIS_SDK_DIR', reqOrbisSdk)
            config.writeEnvVar('PATH', core.shell.os_path(reqOrbisSdk + '/host_tools/bin') + os.pathsep + path)
        self.clang_version = core.shell.capture_text('orbis-clang.exe --version')
        core.log.message('- CLANG: '+self.clang_version)
        
    ''' Add device '''
    def addDevice(self, deviceIp, contextDir=None, exitOnError=True, env=None):
        result = core.shell.capture_text(cmd='orbis-ctrl add '+deviceIp, contextDir=contextDir, exitOnError=exitOnError, env=env)
        core.log.message('orbis-ctrl result: '+str(result))
        if '<unknown> 0.000' in result:
            if exitOnError: core.log.error('Unable to resolve PS4 at "'+deviceIp+'"')
            else: return 1
        return 0
        
    ''' Run application '''
    def run(self, target, workingDirectory, elf, console=True, forceConnect=True, debug=True, kill=True, options=None, contextDir=None, exitOnError=True, env=None):
        cmd = 'orbis-run'
        if console: cmd+=' /console'
        if forceConnect: cmd+=' /forceconnect'
        if debug: cmd+=' /debug'
        if kill: cmd+=' /kill'
        cmd+=' /target '+target+' /workingDirectory "'+workingDirectory+'" /elf "'+elf+'"'
        if options: cmd+=' ' +str(options)
        return core.shell.run(cmd=cmd, contextDir=contextDir, exitOnError=exitOnError, env=env)
 
