'''
    Teamcity Adaptor
'''
import core

class TeamcityAdaptor:
    ''' Constructor '''
    def __init__(self, serverUrl):
        core.log.message('Creating Teamcity adaptor')
        self.serverUrl = serverUrl
        core.log.message('- Server URL: '+self.serverUrl)
     
''' Escape strings suitable for Teamcity parser '''
def _escape(text):
    return text.replace('\'', '|\'').replace('\n', '|\n').replace('\r', '|\r').replace(r'\u', '|0x').replace('|', '||').replace('[', '|[').replace(']', '|]')

''' Test Suite Class '''
class TestSuite:
    ''' Constructor '''
    def __init__(self, name):
        self.name = name
    ''' Start Test Suite '''
    def start(self):
        core.log.emit('##teamcity[testSuiteStarted name="%s"]' % _escape(self.name))
    ''' Finish Test Suite '''
    def finish(self):
        core.log.emit('##teamcity[testSuiteFinished name="%s"]' % _escape(self.name))

''' Test Class '''
class Test:
    ''' Test status '''
    STATUS_NORMAL   = 'normal'
    STATUS_WARNING  = 'warning'
    STATUS_FAILURE  = 'failure'
    STATUS_ERROR    = 'error'
    ''' Constructor '''
    def __init__(self, name):
        self.name = _escape(name)
    ''' Start test '''
    def start(self):
        self.dt = datetime.datetime.now()
        core.log.emit('##teamcity[testStarted name="%s"]' % self.name)
    ''' Write to test stdout '''
    def stdout(self, text):
        core.log.emit('##teamcity[testStdOut name="%s" out="%s"]' % (self.name, _escape(text)))
    ''' Write to test stderr '''
    def stderr(self, text):
        core.log.emit('##teamcity[testStdErr name="%s" out="%s"]' % (self.name, _escape(text)))
    ''' Fail this test '''
    def fail(self, message = 'No message given', details = 'No details given'):
        core.log.emit('##teamcity[testFailed name="%s" message="%s" details="%s"]' % (self.name, _escape(message), _escape(details)))
    ''' Write test status '''
    def status(self, text, status = STATUS_NORMAL, errorDetails = 'N/A'):
        core.log.emit('##teamcity[message text="%s" status="%s" errorDetails="%s"]' % (_escape(text), status, _escape(errorDetails)))
    ''' Finish test '''
    def finish(self):
        duration = datetime.datetime.now().microsecond - self.dt.microsecond
        core.log.emit('##teamcity[testFinished name="%s" duration="%d"]' % (self.name, duration))
