'''
XCode Adaptor
'''
import core

''' Invoke lipo create '''
def lipo_create(src_1, src_2, out, contextDir=None, exitOnError=True):
    src_1 = core.shell.os_path(src_1)
    src_2 = core.shell.os_path(src_2)
    out = core.shell.os_path(out)
    core.log.important('Combining "' + src_1 + '" and "' + src_2 + '" to "' + out + '"...')
    result = core.shell.run('lipo -create '+src_1 + ' ' + src_2+' -output '+out, exitOnError=exitOnError, contextDir=contextDir)
    return result

''' Invoke lipo info '''
def lipo_info(file, contextDir=None, exitOnError=True):
    file = core.shell.os_path(file)
    core.log.important('Querying lipo info for "' + file +'"...')
    result = core.shell.run('lipo -info '+core.shell.os_path(file), exitOnError=exitOnError, contextDir=contextDir)
    return result

''' Export archive (create .IPA file) '''
def export_archive(archivePath, exportPath, exportOptionsPlist, options='', contextDir=None, exitOnError=True):
    result = core.shell.run( cmd='xcodebuild -exportArchive -archivePath ' + archivePath + ' -exportPath '+exportPath+' -exportOptionsPlist ' + exportOptionsPlist + ' ' + options, exitOnError=exitOnError, contextDir=contextDir )
    return result

''' Adaptor Object '''
class XCodeAdaptor:
    ''' Constructor '''
    def __init__(self, actions, configuration, project, scheme, destination, options=''):
        core.log.message('Creating XCode adaptor')
        self.version = core.shell.capture('xcode-select -print-path').decode().strip()
        core.log.message('- Version: '+self.version)
        self.actions = actions
        self.configuration = configuration
        self.project = project
        self.scheme = scheme
        self.destination = destination
        self.options = options
        core.log.message('- Actions: '+self.actions)
        core.log.message('- Configuration: '+self.configuration)
        core.log.message('- Project: '+self.project)
        core.log.message('- Scheme: '+self.scheme)
        core.log.message('- Destination: '+self.destination)
        core.log.message('- Options: '+self.options)

    ''' Run xcodebuild '''
    def xcodebuild(self, actions=None, project=None, configuration=None, destination=None, scheme=None, options=None, contextDir=None, exitOnError=True):
        if not actions: actions = self.actions
        if not project: project = self.project
        if not configuration: configuration = self.configuration
        if not destination: destination = self.destination
        if not scheme: scheme = self.scheme
        if not options: options = self.options
        result = core.shell.run( cmd='xcodebuild '+actions+' -configuration ' + configuration + ' -project '+project+' -destination ' + destination + ' -scheme '+scheme+' ' + options, exitOnError=exitOnError, contextDir=contextDir )
        return result

    ''' Export archive delegate '''
    def export_archive(self, archivePath, exportPath, exportOptionsPlist, options = '', contextDir=None, exitOnError=True):
        return adaptor.xcode.export_archive(archivePath, exportPath, exportOptionsPlist, options, contextDir, exitOnError)
    
    ''' Delegate lipo create '''
    def lipo_create(self, src_1, src_2, out, contextDir=None, exitOnError=True):
        return adaptor.xcode.lipo_create(src_1, src_2, out, contextDir, exitOnError)
    
    ''' Delegate lipo info '''
    def lipo_info(self, file, contextDir=None, exitOnError=True):
        return adaptor.xcode.lipo_info(file, contextDir, exitOnError)
