'''
    Framework constants/enumerations
'''
from enum import Enum

''' Framework Exception '''
class AutoException(Exception):
    message = ''
    value = 0
    def __init__(self, message = 'Non given', value = 0):
        self.message = message
        self.value = value
    def getMessage(self):
        return self.message
    def getValue(self):
        return self.value

''' Release Environment '''
class ReleaseEnv(Enum):
    Dev = 'dev'
    Test = 'test'
    Prod = 'prod'

''' Release Target '''
class ReleaseTarget(Enum):
    S3 = 'S3'
    Artifactory = 'Artifactory'
  
''' Build Type '''
class BuildType(Enum):
    Debug = 'Debug'
    Release = 'Release'

''' Job Platform '''
class Platform(Enum):
    Android = 'Android'
    AndroidWeb = 'AndroidWeb'
    ChromeCast = 'ChromeCast'
    iOS = 'iOS'
    iOSWeb = 'iOSWeb'
    OSX = 'OSX'
    Posix = 'Posix'
    PS4 = 'PS4'
    tvOS = 'tvOS'
    VideoJS = 'VideoJS'
    Web = 'Web'
    XboxOne = 'XboxOne'

''' Job Action '''
class Action(Enum):
    Build = 'Build'
    Test = 'Test'
    Release = 'Release'

''' Test Type '''
class TestType(Enum):
    Unit = 'Unit'
    Integration = 'Integration'
    E2E = 'E2E'
    Custom = 'Custom'
