'''
HTTP Functionality Wrapper
'''
import core
import requests

def uploadFile(source, url, headers={}):
    core.log.message("Uploading '"+source+"' to '"+url+"'...")
    status = False
    with open(source, 'rb') as fp:
        data = fp.read()
        result = requests.put(url, data=data, headers=headers)
        if result.status_code == 200: status = True
        core.log.message("HTTP/"+str(result.status_code))
    return status

def downloadFile(url, destination):
    core.log.message("Downloading '"+url+"' to '"+destination+"'...")
    response = requests.get(url, allow_redirects=True)
    open(destination, 'wb').write(response.content)
    return True
