'''
Parser Utilities
'''
import re

''' Parse file and return array of name/value pairs '''
def key_value(file, keys, separator='='):
    result = []
    with open(file, 'r') as handle:
        line = handle.readline()
        while line:
            match = line.split(separator, 1)
            if match:
                length = len(match)
                key = match[0].strip()
                if key in keys:
                    if len(match) == 2: value = match[1].strip()
                    else: value = '' # Key present but no value
                    item = tuple([key, value])
                    result.append(item)
            line = handle.readline()
    return result
