'''
util.py
Contains miscellanous utilities
'''
import core
import datetime
import json

''' Return current time with millisecond as string '''
def now():
    return str(datetime.datetime.now())

''' Stops framework execution '''
def halt():
    raise core.const.AutoException('BREAKPOINT', -1)

''' Find result XML '''
def findResultXML(path):
    return core.shell.find('*.xml', path, findFiles=True, findDirs=False)

''' Publish a file or directory '''
def publish(src, dst):
    core.log.important('Publishing: "'+src+'" => "'+dst+'"')
    core.shell.copy(src, dst)
    return None

''' Publish list of objects '''
def publishObjects(src, dst, objs):
    for obj in objs:
        path, file = core.shell.path_split(obj)
        publish(src + '/' + obj, dst + '/' + file)

''' Publish file(s) matching wildcard '''
def publishObjectsWildcard(src, dst, wildcard):
    publishObjects(src, dst, _wildcardMatches(src, core.shell.match(wildcard, src)))

''' Publish file(s) matching pattern and root path recursively '''
def publishObjectsWildcardRecursively(src, dst, wildcard):
    publishObjects(src, dst, _wildcardMatches(src, core.shell.find(wildcard, src, findDirs=False)))

''' Helper processing wildcard matches '''
def _wildcardMatches(root, matches):
    offset = len(root) + 1
    objs = []
    for match in matches:
        objs.append(match[offset:])
    return objs

''' Publish test results '''
def publishTestResults(src, dst):
    publish(src, dst)
    return findResultXML(dst)

''' Read JSON file '''
def readJsonFile(path):
    dict = None
    with open(path, 'r') as fh:
        dict = json.load(fh)
    return dict

''' Write JSON to file '''
def writeJsonFile(dict, path):
    with open(path, 'w') as fh:
        json.dump(dict, fh)
