'''
Android Build Job
'''
import core
import jobs.config
from adaptor.gradle import GradleAdaptor

class Runner:
    ''' Execute job '''
    def execute(self, config):
        gradleAdaptor = GradleAdaptor(config)
    
        options = ''
        contextDir = core.shell.os_path(config.getRootDir() + '/platforms/android')
        if config.getJobClean(): options += 'clean '
        options += 'assembleDebug assembleAndroidTest assembleRelease javadocJar'
        gradleAdaptor.gradlew(config, options, contextDir=contextDir)
        
        # Create the android artifact
        rootDir = config.getRootDir()
        outDir = config.getOutDir()

        # Copy prebuild sample application
        apkDir = rootDir + '/examples/android/build/outputs/apk'
        core.util.publishObjects(apkDir + '/release', outDir + '/artifact/sample', ['app-release-unsigned.apk'])
        
        # Copy JAVA packages
        javaLibraryDir = rootDir + '/platforms/android/library/build/outputs/aar'
        core.util.publishObjects(javaLibraryDir, outDir + '/artifact', ['library-debug.aar', 'library-release.aar'])
   
        # Copy C++ headers
        includeDir = rootDir + '/include/playercore'
        core.util.publishObjectsWildcard(includeDir, outDir + '/artifact/include/playercore', '*.*h*')
        includeDir += '/platform'
        core.util.publishObjectsWildcard(includeDir, outDir + '/artifact/include/playercore/platform', '*.*h*')
        includeDir += '/android'
        core.util.publishObjectsWildcard(includeDir, outDir + '/artifact/include/playercore/platform/android', '*.*h*')

        # Copy test artifacts
        testDir = rootDir + '/test/integration/app/android/build/outputs/apk'
        core.util.publishObjects(testDir + '/androidTest/debug', outDir + '/test', ['testApp-debug-androidTest.apk'])
        core.util.publishObjects(testDir + '/debug', outDir + '/test', ['testApp-debug.apk'])
        return 0
