'''
Android Test Job
---------------------------------------------------------------------------------------------
Supports testing in the emulator and on devicefarm
---------------------------------------------------------------------------------------------
AUTO_TEST_HOST: Specifies the host ('Devicefarm' or 'Emulator')
AUTO_BUILD_TYPE: (Optional) Set the build type of the test application and SDK ('Debug' or 'Release'). The default is 'Debug'

Emulator:
AUTO_TEST_LIVEURL: https://www.twitch.tv/bufferbunny
AUTO_TEST_VODURL:

Devicefarm:
AUTO_AWS_REGION: The AWS region
AUTO_AWS_ACCESSKEY: Public Access Key
AUTO_AWS_SECRETKEY: Private Access Key
AUTO_DEVICEFARM_PROJECT: Devicefarm Project
AUTO_DEVICEFARM_DEVICEPOOL: Devicefarm Device Pool
'''
import core
import jobs.config
from adaptor.devicefarm import DeviceFarmAdaptor
from adaptor.gradle import GradleAdaptor

class Runner:
    ''' Execute job '''
    def execute(self, config):
        # Obtain jobs.specific test configuration
        jobs.config.configureTesting(config, restrict={core.const.TestType.Integration}, default=core.const.TestType.Integration)
        # TODO: Provision the test artifacts from persistent storage
        core.shell.copy(config.getOutDir()+'/../build/test/testApp-debug.apk', config.getOutDir())
        core.shell.copy(config.getOutDir()+'/../build/test/testApp-debug-androidTest.apk', config.getOutDir())
        # Run requested test method
        host = config.jobSetting('test.host')
        if host == jobs.config.TestHost.Emulator:
            return self.testOnEmulator(config)
        elif host == jobs.config.TestHost.DeviceFarm:
            return self.testOnDeviceFarm(jobs.config.configureDevicefarmTesting(config))
        return 0
   
    ''' Run test on emulator '''
    def testOnEmulator(self, config):
        core.log.error('Not implemented')
        return 0
    
    ''' Run tests on AWS devicefarm '''
    def testOnDeviceFarm(self, config):
        devicefarmAdaptor = DeviceFarmAdaptor(config, core.const.Platform.Android)
        devicefarmAdaptor.execute(config)
        return 0

