'''
Posix Build Job
'''

import core
from adaptor.cmake import CMakeAdaptor

class Runner:
    ''' Execute Job '''
    def execute(self, config):
        self.buildArtifact(config, 'release')
        return 0
    
    def buildArtifact(self, config, buildType):
        workDir = core.shell.os_path(config.getWorkDir())
        cmakeAdaptor = CMakeAdaptor(generator='"Unix Makefiles"', root=config.getRootDir(), buildType=buildType, contextDir=workDir)
        cmakeAdaptor.generate(params='-DCMAKE_C_COMPILER=clang -DCMAKE_CXX_COMPILER=clang++ -DENABLE_ADDRESS_SANITIZER=OFF -DBUILD_TESTS=OFF -DENABLE_CODE_COVERAGE=OFF')
        core.shell.run('make -j 8', contextDir=workDir)
        outDir = core.shell.os_path(config.getOutDir() + '/artifact')
        targetExtInclude=core.shell.os_path(outDir+'/external/include/')
        targetExtLibs=core.shell.os_path(outDir+'/external/lib/'+buildType+'/')
        targetIntInclude=core.shell.os_path(outDir+'/include/')
        targetIntLibs=core.shell.os_path(outDir+'/lib/'+buildType+'/')
        core.shell.mkdirs([outDir, targetExtInclude, targetExtLibs, targetIntInclude, targetIntLibs])
        core.shell.run('cp -rf '+core.shell.os_path(workDir+'/external/include/*')+' '+targetExtInclude, shell=True)
        core.shell.run('cp -f '+core.shell.os_path(workDir+'/external/lib/*.a')+' '+targetExtLibs, shell=True)
        core.shell.run('cp -rf '+core.shell.os_path(config.getRootDir()+'/include')+' '+targetIntInclude, shell=True)
        core.shell.run('cp -f '+core.shell.os_path(workDir+'/*.a')+' '+targetIntLibs, shell=True)
        return 0

