'''
POSIX Test Job
'''

import core
from adaptor.cmake import CMakeAdaptor
import jobs.config

class Runner:
    ''' Execute Job '''
    def execute(self, config):
        jobs.config.configureTesting(config, restrict={core.const.TestType.Unit}, default=core.const.TestType.Unit)
        if config.jobSetting('test.type')==core.const.TestType.Unit:
            return self.unitTesting(config)
        return 0
    
    ''' Run UNIT testing '''
    def unitTesting(self, config):
        buildType=config.jobSetting('test.buildtype')
        cmakeAdaptor = CMakeAdaptor(generator='"Unix Makefiles"', root=config.getRootDir(), buildType=buildType, contextDir=config.getWorkDir())
        cmakeAdaptor.generate(params='-DCMAKE_C_COMPILER=clang -DCMAKE_CXX_COMPILER=clang++ -DENABLE_ADDRESS_SANITIZER=OFF -DBUILD_TESTS=ON -DENABLE_CODE_COVERAGE=ON -DCODE_COVERAGE_FORMAT=xml')
        core.shell.run('make -j 8', contextDir=config.getWorkDir())
        core.shell.run('ctest --output-on-failure --timeout 900 --verbose', shell=True, contextDir=config.getWorkDir())
        core.shell.copy(config.getWorkDir() + '/test/unit/unit_test_main.xml', config.getOutDir()+'/unit_test_main.xml')
        return 0

