'''
PS4 Build Job
'''

import core
import jobs.config
from adaptor.cmake import CMakeAdaptor
from adaptor.ps4 import PS4Adaptor

class Runner:
    ''' Execute Job '''
    def execute(self, config):
        jobs.config.configureBuild(config)
        self.ps4adaptor = PS4Adaptor(config)
        if not config.jobSetting('build.cmakeonly'):
            self.buildArtifact(config, 'debug')
            self.buildArtifact(config, 'release')
            self.buildDistribution(config)
        else:
            self.buildArtifact(config)
        return 0
    
    ''' Build the sample artifact for selecte build type '''
    def buildArtifact(self, config, buildType=None):
        cmakeAdaptor = CMakeAdaptor(executable=core.shell.os_path(config.getRootDir()+'/vendor/ps4_cmake_prebuilt/bin/cmake.exe'),generator='"Visual Studio 14 2015 Orbis"', 
            root=config.getRootDir(), toolChain=core.shell.os_path(config.getRootDir()+'/cmake/toolchain/ps4.cmake'), buildType=buildType, contextDir=config.getWorkDir(), env=config.getEnv())
        cmakeAdaptor.generate(params='-DBUILD_EXAMPLES=ON -DENABLE_ADDRESS_SANITIZER=OFF -DBUILD_TESTS=ON -DENABLE_CODE_COVERAGE=OFF -DBUILD_UNIFIED_LIB=ON -DBUILD_DEPENDENCY_SUBMODULES=ON')
        if not config.jobSetting('build.cmakeonly'):
            cmakeAdaptor.build(buildToolOptions='/p:Configuration='+buildType+' /p:Platform=Orbis /v:m /m')
            outDir = core.shell.os_path(config.getOutDir() + '/test')
            core.shell.copy(config.getWorkDir()+'/bin/'+buildType+'/integrationTestRunner.elf', outDir+'/'+buildType+'/TestRunner.elf')
    
    ''' Run distribution build '''
    def buildDistribution(self, config):
        # Note: We will execute the supplied batch files on purpose
        #       to simulate and validate the external build process
        workDir = core.shell.os_path(config.getRootDir()+'/dist/ps4')
        core.shell.run(cmd=core.shell.os_path(workDir + '/dist.cmd "'+config.getWorkDir()+'"'))
        core.shell.run(cmd='build.cmd',contextDir=workDir)
        # Publish artifacts
        outDir = core.shell.os_path(config.getOutDir() + '/artifact')
        core.shell.copy(workDir, outDir)        
        core.shell.copy(outDir+'/build/Release/SampleApp.elf', outDir + '/sample/bin/SampleApp.elf')
        core.shell.remove(outDir+'/build')
        core.shell.remove(outDir+'/dist.cmd')
        core.shell.run(cmd='doxygen', contextDir=config.getWorkDir())
        core.shell.copy(config.getWorkDir()+'/docs/html', outDir+'/docs')
   
