'''
PS4 Test Job
'''

import core
import jobs.config
from adaptor.ps4 import PS4Adaptor

class Runner:
    ''' Execute Job '''
    def execute(self, config):
        self.ps4adaptor = PS4Adaptor(config)
        jobs.config.configureTesting(config, restrict={core.const.TestType.Integration, core.const.TestType.Custom}, default=core.const.TestType.Integration)
        testType = config.jobSetting('test.type')
        if testType==core.const.TestType.Integration:
            return self.integrationTesting(config)
        elif testType==core.const.TestType.Custom:
            return self.customTesting(config)
        return 1
     
    ''' Integration Testing '''
    def integrationTesting(self, config):
        buildType = config.jobSetting('test.buildtype')
        deviceIp = config.jobSetting('test.deviceip')
        core.log.important('Targeting physical device at "'+deviceIp+'" for testing...')
        self.ps4adaptor.addDevice(deviceIp)
        buildDir=config.getOutDir()+'/../build'
        workingDirectory = core.shell.os_path(buildDir+'/artifact/sample/data')
        elf=core.shell.os_path(buildDir+'/test/'+buildType+'/testRunner.elf')
        resultXmlPath=core.shell.os_path(config.getOutDir()+'/result.xml')
        options='"'+config.jobSetting('test.liveurl')+'" --gtest_filter="'+config.jobSetting('test.filter')+'" --gtest_output="xml:/host/'+resultXmlPath+'"'
        self.ps4adaptor.run(target=deviceIp, workingDirectory=workingDirectory, elf=elf, options=options, env=config.getEnv())
        core.util.findResultXML(config.getOutDir())
        return 0

    ''' Run custom testing '''
    def customTesting(self, config):
        # TODO: Download pre-compiled test package from artifactory/s3
        # HACK-START
        jobConfig = config.getJobConfig()
        jobConfig['test.liveurl'] = jobConfig['test.manifesturl']
        jobConfig['test.filter'] = '*'
        jobConfig['test.deviceip'] = config.parseString('AUTO_TEST_DEVICEIP')
        jobConfig['test.buildtype'] = core.const.BuildType.Debug.value
        # HACK-END
        return self.integrationTesting(config)
