'''
Define the job routes available for this repository
'''
import core
import jobs

''' Return available job routes '''
def getJobRoutes():
    return {
        core.const.Platform.Android: {
            core.const.Action.Build: jobs.android.build.Runner,
            core.const.Action.Test: jobs.android.test.Runner,
        },
        core.const.Platform.iOS: {
            core.const.Action.Build: jobs.ios.build.Runner,
            core.const.Action.Test: jobs.ios.test.Runner,
        },
        core.const.Platform.tvOS: {
            core.const.Action.Build: jobs.ios.build.Runner,
            core.const.Action.Test: jobs.tvos.test.Runner,
        },
        core.const.Platform.Web: {
            core.const.Action.Build: jobs.web.build.Runner,
            core.const.Action.Test: jobs.web.test.Runner,
            core.const.Action.Release: jobs.web.release.Runner,
        },
        core.const.Platform.Posix: {
            core.const.Action.Build: jobs.posix.build.Runner,
            core.const.Action.Test: jobs.posix.test.Runner,
        },
        core.const.Platform.PS4: {
            core.const.Action.Build: jobs.ps4.build.Runner,
            core.const.Action.Test: jobs.ps4.test.Runner,
        },
        core.const.Platform.XboxOne: {
            core.const.Action.Build: jobs.xboxone.build.Runner,
            core.const.Action.Test: jobs.xboxone.test.Runner,
        },
    }
    