'''
Web Build Job
AUTO_PLATFORM=web
AUTO_ACTION=build
'''

import core
from adaptor.npm import NPMAdaptor

class Runner:
    ''' Execute Job '''
    def execute(self, config):
        self.npmAdaptor = NPMAdaptor(config)
        self.artifactDir = core.shell.os_path(config.getRootDir() + '/artifacts')
        self.buildDir = core.shell.os_path(config.getRootDir() + '/build_js')
        self.build(config)
        self.package(config)
        self.checkBuildMetrics(config)
        return 0
    
    def build(self, config):
        core.shell.run('bash -c "source ' + core.shell.home_path()+'/emsdk-portable/emsdk_env.sh && npm run bundle --unsafe_perm"', contextDir=config.getRootDir(), shell=True)
        return 0
    
    def package(self, config):
        # Package artifact
        artifactName = core.shell.capture('npm pack', contextDir=config.getRootDir()).decode().strip()
        core.shell.move(artifactName, core.shell.os_path(config.getOutDir() + '/' + artifactName))
        # Get version
        version = core.shell.capture('node '+core.shell.os_path(config.getRootDir()+'/scripts/version.js')).decode().strip()
        core.log.message('Version: '+version)
        # Create directories
        outDir = config.getOutDir()
        core.shell.mkdir(outDir + '/ads')
        core.shell.mkdir(outDir + '/chromecast')
        core.shell.mkdir(outDir + '/qa')
        core.shell.mkdir(outDir + '/qa/chromecast')
        core.shell.mkdir(outDir + '/deploy')
        core.shell.mkdir(outDir + '/deploy/' + version)
        # Write version files
        core.shell.write_file(outDir + '/version.txt', version)
        # GZIP-9 the WASM files
        core.shell.run(cmd='gzip -9 '+core.shell.os_path(self.artifactDir + '/wasmworker.wasm'))
        core.shell.run(cmd='mv wasmworker.wasm.gz wasmworker.wasm', contextDir=self.artifactDir)
        core.shell.run(cmd='gzip -9 '+core.shell.os_path(self.artifactDir + '/wasmworker.min.wasm'))
        core.shell.run(cmd='mv wasmworker.min.wasm.gz wasmworker.min.wasm', contextDir=self.artifactDir)
        # Copy files to locations
        copy_list = [
            ('examples/web/index.html', 'index.html'),
            ('examples/web/videojs.html', 'videojs.html'),
            ('test/integration/app/web/test.html', 'test.html'),
            ('artifacts/samplemediaplayer.js', 'samplemediaplayer.js'),
            ('artifacts/videojs-hls-tech.js', 'videojs-hls-tech.js'),
            ('artifacts/videojs-bundle.js', 'videojs-bundle.js'),
            ('artifacts/worker.js', 'worker.js'),
            ('artifacts/wasmworker.js', 'wasmworker.js'),
            ('artifacts/wasmworker.wasm', 'wasmworker.wasm'),
            ('artifacts/testplayer.js', 'testplayer.js'),
                     
            ('examples/web/ads/videojs_5.vast.vpaid.js', 'ads/videojs_5.vast.vpaid.js'),

            ('artifacts/chromecast-mediaplayer.js', 'chromecast/chromecast-mediaplayer.js'),
            ('artifacts/worker.js', 'chromecast/worker.js'),
            ('artifacts/wasmworker.js', 'chromecast/wasmworker.js'),
            ('artifacts/wasmworker.wasm', 'chromecast/wasmworker.wasm'),

            ('artifacts/samplemediaplayer.min.js', 'qa/samplemediaplayer.min.js'),
            ('artifacts/videojs-hls-tech.min.js', 'qa/videojs-hls-tech.min.js'),
            ('artifacts/videojs-bundle.min.js', 'qa/videojs-bundle.min.js'),
            ('examples/web/index.html', 'qa/index.html'),
            ('examples/web/videojs.html', 'qa/videojs.html'),
            ('artifacts/worker.min.js', 'qa/worker.min.js'),
            ('artifacts/wasmworker.min.js', 'qa/wasmworker.min.js'),
            ('artifacts/wasmworker.min.wasm', 'qa/wasmworker.min.wasm'),
        ]
        # Copy file list
        for item in copy_list:
            core.shell.copy(config.getRootDir()+'/'+item[0], outDir+'/'+item[1])
        # Publish artifacts to deployment directory
        deployDir = core.shell.os_path(outDir + '/deploy')
        versionDir = core.shell.os_path(deployDir + '/' + version)
        # - Minimized js/wasm
        core.shell.run(cmd='cp '+core.shell.os_path(self.artifactDir+'/*.min.js') + ' ' + versionDir, shell=True)
        core.shell.run(cmd='cp '+core.shell.os_path(self.artifactDir+'/*.min.wasm') + ' ' + versionDir, shell=True)
        # - Chromecast receiver app
        core.shell.run(cmd='cp -R '+core.shell.os_path(config.getRootDir() + '/platforms/web/chromecast/.') + ' ' + versionDir, shell=True)
        # - Video-js sample
        core.shell.run(cmd='cp '+core.shell.os_path(self.artifactDir+'/*.min.wasm') + ' ' + versionDir, shell=True)
        return 0

    def checkBuildMetrics(self, config):
        pass
