'''
    Release Web Job
'''

import core
from adaptor.s3 import S3Adaptor
from adaptor.npm import NPMAdaptor
import jobs.config

class Runner:
    ''' Execute Job '''
    def execute(self, config):
        jobs.config.configureRelease(config)
        jobConfig = config.getJobConfig()
        self.version = core.shell.capture('cat version.txt', contextDir=jobConfig['release.artifact']).decode().strip()
        self.branch = jobConfig['release.branch']
        self.target = jobConfig['release.target']
        self.artifactDir = jobConfig['release.artifact']
        self.env = jobConfig['release.env']
        if self.target == core.const.ReleaseTarget.S3:
            self.uploadToS3(config)
        elif self.target == core.const.ReleaseTarget.Artifactory:
            self.uploadToArtifactory(config)
        return 0

    ''' Upload helper '''
    def _uploadToS3(self, config, dir, bucket, object, cacheControl):
        s3Adaptor = config.getJobConfig().get('aws.s3')
        s3Adaptor.uploadDirectory(directory=dir, bucket=bucket, object=object, extraArgs={ 'CacheControl': cacheControl})
        listOfWasmFiles = core.shell.find('*.wasm', dir, findDirs=False)
        for file in listOfWasmFiles:
            target = core.shell.os_path(object + file[len(dir):])
            s3Adaptor.uploadFile(file, bucket, target, extraArgs={ 'CacheControl': cacheControl, 'ContentType': 'application/wasm', 'ContentEncoding': 'gzip' })

    ''' Upload artifact to S3 '''
    def uploadToS3(self, config):
        jobConfig = config.getJobConfig()
        s3Adaptor = jobConfig['aws.s3']
        bucket = jobConfig['release.s3.bucket']
        deployDir = core.shell.os_path(self.artifactDir + '/deploy/'+self.version)
        if self.env == core.const.ReleaseEnv.Dev:
            self._uploadToS3(config, self.artifactDir, bucket, 'origin/' + self.branch, 'public, max-age=60')
        elif self.env == core.const.ReleaseEnv.Test:
            self._uploadToS3(config, deployDir, bucket, self.branch, 'public, max-age=60')
            self._uploadToS3(config, deployDir, bucket, self.version, 'public, max-age=60')
        elif self.env == core.const.ReleaseEnv.Prod:
            self._uploadToS3(config, deployDir, bucket, self.version, 'public, max-age=31536000')
        return 0

    ''' Upload artifact to Artifactory '''
    def uploadToArtifactory(self, config):
        npmAdaptor = NPMAdaptor(config)
        artifactoryAdaptor = config.getJobConfig().get('release.artifactory')
        host, user, secret, registry = artifactoryAdaptor.getConfig()
        core.shell.run('curl -u'+user+':'+secret+' '+host+' > '+core.shell.os_path(core.shell.home_path()+'/.npmrc'), shell=True, verbose=False)
        npmAdaptor.config('set registry '+registry)
        artifact = core.shell.os_path(self.artifactDir + '/player-core-'+self.version+'.tgz')
        npmAdaptor.publish('--registry '+registry, artifact)
        return 0
