'''
Web Test Job
'''

import core
from adaptor.npm import NPMAdaptor
import jobs.config

class Runner:
    ''' Execute Job '''
    def execute(self, config):
        jobs.config.configureTesting(config, restrict={core.const.TestType.Unit, core.const.TestType.E2E, core.const.TestType.Custom}, default=core.const.TestType.Unit)
        self.npmAdaptor = NPMAdaptor(config)
        testType = config.jobSetting('test.type')
        if testType==core.const.TestType.Unit:
            return self.unitTesting(config)
        elif testType==core.const.TestType.E2E:
            return self.E2ETesting(config)
        elif testType==core.const.TestType.Custom:
            return self.customTesting(config)
        return 1 # Should not happen
    
    ''' Run UNIT testing '''
    def unitTesting(self, config):
        self.npmAdaptor.install(config.getEnv())
        self.npmAdaptor.runScript('test', config.getEnv())
        # Unit testing do not publish XML
        # TODO: core.util.publishTestResults('results', core.shell.join_path(config.getOutDir(), 'results'))
        return 0
    
    ''' Run E2E testing '''
    def E2ETesting(self, config):
        method = config.jobSetting('test.method')
        # TODO: CDP testing creates process zombies
        if method==jobs.config.E2ETestMethod.ChromeDevTools:
            core.shell.run('pkill chrome', exitOnError=False)
            core.shell.run('pkill node', exitOnError=False)
        self.npmAdaptor.install(config.getEnv())
        self.npmAdaptor.runScript('e2e:' + method.value, config.getEnv())
        core.util.publishTestResults('results', core.shell.join_path(config.getOutDir(), 'results'))
        return 0

    ''' Run custom testing '''
    def customTesting(self, config):
        # This implements "on-demand" testing (Utilizing the E2E-BrowserGrid framework)
        from adaptor.selenium import SeleniumAdaptor
        from adaptor.browsergrid import BrowserGridAdaptor
        seleniumAdaptor = SeleniumAdaptor(config, config.parseInt('AUTO_SELENIUM_MAXINSTANCES', 4))
        config.writeEnvVar('PLAYER_BASEURL', 'https://cvp-web.internal.justin.tv/'+config.jobSetting('test.version')+'/test.html')
        config.writeEnvVar('PLAYER_LIVEURL', config.jobSetting('test.manifesturl'))
        config.writeEnvVar('PLAYER_VODURL', config.jobSetting('test.manifesturl'))
        gridAdaptor = BrowserGridAdaptor(config, config.parseString('AUTO_GRID_HOST', 'cbg.internal.justin.tv'), config.parseString('AUTO_GRID_USER', 'player-core'), config.parseString('AUTO_GRID_SECRET'))
        self.npmAdaptor.install(config.getEnv())
        self.npmAdaptor.runScript('e2e:grid', config.getEnv())
        core.util.publishTestResults('results', core.shell.join_path(config.getOutDir(), 'results'))
        return 0
