'''
XboxOne Build Job
'''

import core
import jobs.config
from adaptor.cmake import CMakeAdaptor
from adaptor.xboxone import XboxOneAdaptor

class Runner:
    ''' Execute Job '''
    def execute(self, config):
        jobs.config.configureBuild(config)
        self.xboxOneAdaptor = XboxOneAdaptor(config)
        if not config.jobSetting('build.cmakeonly'):
            self.buildArtifact(config, 'debug')
            self.buildArtifact(config, 'release')
            self.publishTestApps(config)
            self.buildDistribution(config)
        else:
            self.buildArtifact(config)
        return 0
    
    ''' Build the sample artifact for selecte build type '''
    def buildArtifact(self, config, buildType=None):
        # Build samples and test applications (aka everything)
        cmakeAdaptor = CMakeAdaptor(generator='"Visual Studio 15 Win64"', root=config.getRootDir(), toolChain=core.shell.os_path(config.getRootDir()+'/cmake/toolchain/WinStore.cmake'), buildType=buildType, contextDir=config.getWorkDir())
        cmakeAdaptor.generate(params='-DBUILD_EXAMPLES=ON -DBUILD_TESTS=ON -DENABLE_ADDRESS_SANITIZER=OFF -DENABLE_CODE_COVERAGE=OFF -DBUILD_UNIFIED_LIB=ON -DBUILD_DEPENDENCY_SUBMODULES=ON')
        if not config.jobSetting('build.cmakeonly'):
            cmakeAdaptor.build(buildToolOptions='/p:Configuration='+buildType+' /m')
        
    ''' Publish test apps '''
    def publishTestApps(self, config):
        # Copy integration test packages
        srcDir = core.shell.os_path(config.getWorkDir() + '/test/integration/app/uwp/AppPackages/integrationTestRunner')
        dstDir = core.shell.os_path(config.getOutDir() + '/test')
        core.shell.copy(srcDir, dstDir)
   
    ''' Run distribution build '''
    def buildDistribution(self, config):
        # Note: We will execute the supplied batch files on purpose
        #       to simulate and validate the external build process
        workDir = core.shell.os_path(config.getRootDir()+'/dist/xboxone')
        core.shell.run(cmd=core.shell.os_path(workDir + '/dist.cmd '+config.getWorkDir()), contextDir=config.getRootDir())
        core.shell.run(cmd='build.cmd',contextDir=workDir)
        # Publish artifacts
        outDir = core.shell.os_path(config.getOutDir() + '/artifact')
        core.shell.copy(workDir, outDir)     
        core.shell.copy(outDir+'/build/AppPackages/SampleApp/SampleApp_1.0.0.0_x64_Test', outDir + '/sample/bin/SampleApp_1.0.0.0_x64_Test')
        core.shell.remove(outDir+'/build')
        core.shell.remove(outDir+'/dist.cmd')
        core.shell.run(cmd='doxygen', contextDir=config.getWorkDir())
        core.shell.copy(config.getWorkDir()+'/docs/html', outDir+'/docs')
   
