'''
XboxOne Test Job
'''

import core
import jobs.config
from adaptor.xboxone import XboxOneAdaptor

class Runner:
    ''' Execute Job '''
    def execute(self, config):
        self.xboxOneAdaptor = XboxOneAdaptor(config)
        jobs.config.configureTesting(config, restrict={core.const.TestType.Integration}, default=core.const.TestType.Integration)
        if config.jobSetting('test.type')==core.const.TestType.Integration:
            return self.integrationTesting(config) 
        return 1 # should not happen
     
    ''' Integration Testing '''
    def integrationTesting(self, config):
        buildType = config.jobSetting('test.buildtype')
        deviceIp = config.jobSetting('test.deviceip')
        core.log.important('Targeting physical device at "'+deviceIp+'" for integration testing...')
        self.xboxOneAdaptor.addDevice(deviceIp)
        self.xboxOneAdaptor.run(deviceIp)
        core.util.findResultXML(config.getOutDir())
        return 0