#!/bin/bash

# Create release notes between two commits/tags/branches.
# A third 'platform' argument can be added to filter by platform
#
# For example, "./releasenotes.sh v2.0.0 v2.1.0 Web" will generate
# v2.1.0 release notes for web only

if [ "$#" -ge 2 ]; then
    git log --oneline --decorate=no -i --grep "-[0-9]\{1,5\}[[:space:]]$3" $1..$2
else
    echo "usage: releasenotes <prev_version> <new_version> [<platform>]"
fi
