#pragma once

#include "CircularQueue.hpp"
#include "Estimator.hpp"
#include "Filter.hpp"
#include "MovingAverage.hpp"
#include "RequestMetric.hpp"
#include "playercore/Log.hpp"
#include "playercore/MediaSource.hpp"
#include <map>

namespace twitch {
namespace abr {
class BandwidthFilter : public Filter, public MediaSource::Request::Listener {
public:
    BandwidthFilter(Log& log, bool useResponseTime);
    ~BandwidthFilter() override = default;

    static std::string Name;
    const std::string& getName() const override { return Name; }
    bool filter(const std::vector<Quality>& qualities, Filter::Context& context) override;
    void onStatistics(const Statistics& statistics, const Quality& quality) override;
    void onStreamChange() override;

    void onRequestSent(const MediaSource::Request& request) override;
    void onResponseReceived(const MediaSource::Request& request) override;
    void onResponseBytes(const MediaSource::Request& request, size_t bytes) override;
    void onResponseEnd(const MediaSource::Request& request) override;
    void onRequestError(const MediaSource::Request& request, int error) override;

    int getAverageBitrate() const;
    int getBandwidthEstimate() const;
    const CircularQueue<RequestMetric>& getTransferHistory() const { return m_transferHistory; }
    void setInitialBitrate(int bitrate);
    void setLowLatencyMode(bool enable);

private:
    int getEstimate(const Filter::Context& context);
    Estimator& getEstimator(const MediaSource::Request& request);
    void createEstimator();

    Log& m_log;
    bool m_useResponseTime;
    bool m_streamChanged;
    double m_bandwidthUsage;
    double m_rebufferingUsagePenalty;
    std::map<int, RequestMetric> m_requests;
    int m_initialBitrate;
    std::unique_ptr<Estimator> m_estimator;
    std::unique_ptr<Estimator> m_probeEstimator;

    enum class EstimationMode {
        Normal,
        Probe
    };
    EstimationMode m_estimationMode;
    MovingAverage<int> m_averageBitrate;
    CircularQueue<RequestMetric> m_transferHistory;
};
}
}
