#include "BitrateFilter.hpp"
#include <limits>

namespace twitch {
namespace abr {
std::string BitrateFilter::Name = "BitrateFilter";

BitrateFilter::BitrateFilter()
    : m_minBitrate(0)
    , m_maxBitrate(std::numeric_limits<int>::max())
{
}

bool BitrateFilter::filter(const std::vector<Quality>& qualities, Filter::Context& context)
{
    for (const auto& q : qualities) {
        if (q.bitrate < m_minBitrate || q.bitrate > m_maxBitrate) {
            context.filter(*this, q);
        }
    }
    return true;
}

void BitrateFilter::onStatistics(const Statistics& statistics, const Quality& quality)
{
    (void)statistics;
    (void)quality;
}
}
}
