#pragma once

#include "Filter.hpp"

namespace twitch {
namespace abr {
class BitrateFilter : public Filter {
public:
    BitrateFilter();
    ~BitrateFilter() override = default;

    static std::string Name;
    const std::string& getName() const override { return Name; }

    bool filter(const std::vector<Quality>& qualities, Filter::Context& context) override;
    void onStatistics(const Statistics& statistics, const Quality& quality) override;
    void onStreamChange() override {};
    void setMinBitrate(int bitrate) { m_minBitrate = bitrate; };
    void setMaxBitrate(int bitrate) { m_maxBitrate = bitrate; };

private:
    int m_minBitrate;
    int m_maxBitrate;
};
}
}
