#pragma once

#include "Filter.hpp"
#include "playercore/Log.hpp"

namespace twitch {
namespace abr {
class BufferFilter : public Filter {
public:
    explicit BufferFilter(Log& log);
    ~BufferFilter() override = default;

    static std::string Name;
    const std::string& getName() const override { return Name; }
    bool filter(const std::vector<Quality>& qualities, Filter::Context& context) override;
    void onStatistics(const Statistics& statistics, const Quality& quality) override;
    void onStreamChange() override;
    void setTargetBufferSize(MediaTime duration);
    void setLowLatencyMode(bool enable) { m_lowLatencyMode = enable; }

    MediaTime getMinBufferTarget() const { return m_upSwitchMinBuffer; }

private:
    Log& m_log;
    MediaTime m_upSwitchMinBuffer;
    bool m_lowLatencyMode;
};
}
}
