#pragma once

#include <cstddef>
#include <deque>

namespace twitch {
template <typename T>
class CircularQueue {
public:
    CircularQueue(size_t maxSize)
        : m_maxSize(std::max(static_cast<size_t>(1), maxSize))
    {
    }

    using const_iterator = typename std::deque<T>::const_iterator;
    using const_reverse_iterator = typename std::deque<T>::const_reverse_iterator;

    std::size_t size() const { return m_queue.size(); }
    bool empty() const { return m_queue.empty(); }
    const T& back() const { return m_queue.back(); }
    const_iterator begin() const { return m_queue.begin(); }
    const_iterator end() const { return m_queue.end(); }
    const_reverse_iterator rbegin() const { return m_queue.rbegin(); }
    const_reverse_iterator rend() const { return m_queue.rend(); }
    const T& operator[](size_t pos) const { return m_queue[pos]; }

    void push_back(const T& item)
    {
        while (m_queue.size() >= m_maxSize) {
            m_queue.pop_front();
        }

        m_queue.push_back(item);
    }

private:
    std::size_t m_maxSize;
    std::deque<T> m_queue;
};
}
