#pragma once

#include "Filter.hpp"
#include "TimedMovingAverage.hpp"
#include "playercore/Statistics.hpp"
#include "playercore/platform/Platform.hpp"

namespace twitch {
namespace abr {
class DroppedFrameFilter : public Filter {
public:
    explicit DroppedFrameFilter(Log& log);
    ~DroppedFrameFilter() override = default;

    static std::string Name;
    const std::string& getName() const override { return Name; }
    bool filter(const std::vector<Quality>& qualities, Filter::Context& context) override;
    void onStatistics(const Statistics& statistics, const Quality& quality) override;
    void onStreamChange() override;

private:
    Log& m_log;
    MediaTime m_lastUpdate;
    int m_lastDecodedFrames;
    int m_lastDroppedFrames;
    TimedMovingAverage<int> m_droppedFrameAverage;
    std::set<Quality> m_dropped;
};
}
}
