#include "EWMAEstimator.hpp"

namespace twitch {
namespace abr {
const double MinStableWeight = 0.2;

EWMAEstimator::EWMAEstimator(double alpha, double initialValue, double initialWeight)
    : m_average(alpha, initialValue, initialWeight)
    , m_estimate(static_cast<int>(initialValue))
{
}

void EWMAEstimator::sample(MediaTime time, size_t value)
{
    double seconds = time.seconds();
    if (seconds > 0.0) {
        double bps = (value * 8) / seconds;
        m_average.add(seconds, bps);
    }
}

int EWMAEstimator::estimate()
{
    if (m_average.getTotalWeight() > MinStableWeight) {
        m_estimate = static_cast<int>(m_average.average());
    }

    return m_estimate;
}
}
}
