#pragma once

#include "EWMAverage.hpp"
#include "Estimator.hpp"

namespace twitch {
namespace abr {
class EWMAEstimator : public Estimator {
public:
    EWMAEstimator(double alpha, double initialValue, double initialWeight = 0.0);
    ~EWMAEstimator() override = default;
    void sample(MediaTime time, size_t value) override;
    int estimate() override;
    int getEstimate() const override { return m_estimate; }

    static constexpr double PredictFast = 0.8408964152537146; // fast adaptation to current, exp(log(0.5) / speed)
    static constexpr double PredictSlow = 0.9548416039104165; // slow adaptation to current

private:
    EWMAverage<double> m_average;
    int m_estimate;
};
}
}
