#pragma once

#include <cmath>
#include <numeric>

namespace twitch {
/** Exponentially weighted moving average */
template <typename T>
class EWMAverage {
public:
    EWMAverage(T alpha, T initialValue = T(), T initialWeight = T())
        : m_alpha(alpha)
        , m_initialValue(initialValue)
        , m_initialWeight(initialWeight)
    {
        reset();
    }

    void add(T weight, T value)
    {
        T decay = std::pow(m_alpha, weight);
        m_value = m_value * decay + value * (1 - decay);
        m_totalWeight += weight;
    }

    T average()
    {
        return m_value / (1 - std::pow(m_alpha, m_totalWeight));
    }

    void reset()
    {
        m_value = m_initialValue;
        m_totalWeight = m_initialWeight;
    }

    T getTotalWeight() { return m_totalWeight; }

private:
    T m_alpha;
    T m_initialValue;
    T m_initialWeight;
    T m_value;
    T m_totalWeight;
};
}
